function OSCfunctionSender(block)
% Level-2 M file S-function for applying Sobel filtering  
% (image edge detection demonstration).
%   Copyright 1990-2004 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $    
  
  setup(block);

%endfunction

function setup(block)
  
  %% Register dialog parameter: edge direction 
  block.NumDialogPrms = 3;
  block.DialogPrmsTunable = {'NonTunable','NonTunable','NonTunable'};
 
  %% Register ports
  block.NumInputPorts  = 1;
  block.NumOutputPorts = 0;
  
  %% Setup port properties
  block.SetPreCompInpPortInfoToDynamic;
  %block.SetPreCompOutPortInfoToDynamic;

  block.InputPort(1).DatatypeID   = 0;
  block.InputPort(1).Complexity   = 'Real';
  block.InputPort(1).SamplingMode = 'Sample';
  %block.InputPort(1).Overwritable = false; % No in-place operation
  
   % block.OutputPort(1).DatatypeID   = 0;
   % block.OutputPort(1).Complexity   = 'Real';
   % block.OutputPort(1).SamplingMode = 'Sample';
%   
  %% Register block methods (through MATLAB function handles)
%  block.RegBlockMethod('Outputs', @Output);
  %block.RegBlockMethod('WriteRTW',@WriteRTW);

  %% Block runs on TLC in accelerator mode.
 % block.SetAccelRunOnTLC(true);
 block.RegBlockMethod('Outputs', @Output);
%endfunction


  
  function Output(block)
pause(0.05)
SendOSCMessage(block.DialogPrm(1).Data, block.DialogPrm(2).Data, block.DialogPrm(3).Data,  block.InputPort(1).Data )

function send=SendOSCMessage(address,port,head,data)

%address
%port
%head
%data
% function send=SendOSCMessage(address,port,head,data)
% Encapsulate head and data in OSC protocol then send it with UPD 
% UDP function used is pnet from TCP_UDP_IP toolbox
% INPUT:
% - address: string with IP address (ex: 10.104.11.14)
% - port: int, port number to connect, default= 7770
% - head: head of the OSC protocol must start with '/'
% - data: float vector of data (single matlab type)
% OUTPUT: 
% - size: the size of the sent data
tic
daze=max(size(data));
pnet('closeall');
%display('alrededor')
udp=pnet('udpsocket',3333); %default port to send data. should be changed
pnet(udp,'write',head);
temp1=mod(max(size(head)),4); % check number of zero to add
temp2=4-temp1-1; % number of zero to add
pnet(udp,'write',uint8(0)); % mandatory zero to finish the string
for i=1:temp2 % add zero at the end to get a multiple of 4
    pnet(udp,'write',uint8(0));
end
pnet(udp,'write',','); % comma to start the type tag
for i=1:daze
    pnet(udp,'write','f'); % number of float to write
end
pnet(udp,'write',uint8(0)); % mandatory zero to finish the typetag string
temp1=mod(daze+2,4); % check number of zero to add
if temp1>0
    temp2=4-temp1; % number of zero to add
    for i=1:temp2 % add zero at the end to get a multiple of 4
        pnet(udp,'write',uint8(0));
    end 
end
for i=1:daze % write the data
    pnet(udp,'write',single(data(i)));
end
send=pnet(udp,'writepacket',address,port);
mic = size(send);
pnet('closeall');
toc
